#pragma once

#include "Renderable.h"
#include <GL/glew.h>
#include <GL/GL.h>

namespace graphics {

	class BoxMesh :
		public Renderable
	{
	public:
		BoxMesh();
		BoxMesh(const BoxMesh & pyramid) = delete;
		BoxMesh & operator = (const BoxMesh & pyramid) = delete;
		~BoxMesh();
		void render();
	private:
		GLuint m_VAO;
		/*
		0 -> vertex buffer
		1 -> index buffer
		2 -> normals
		*/
		GLuint m_buffers[3];
	};

};